<?php
$targetDir = "Document/";
$evidenceFiles = [];
$supportingFiles = [];

function saveFiles($filesArray, $prefix) {
    global $targetDir;
    $savedFiles = [];
    foreach ($filesArray['name'] as $key => $name) {
        $tmpName = $filesArray['tmp_name'][$key];
        $filePath = $targetDir . $prefix . "_" . basename($name);
        if (move_uploaded_file($tmpName, $filePath)) {
            $savedFiles[] = $filePath;
        }
    }
    return implode(",", $savedFiles);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $conn = new mysqli("localhost", "username", "password", "alumni_award");
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    $nominee_name = $_POST['nominee_name'];
    $graduation_year = $_POST['graduation_year'];
    $degree_program = $_POST['degree_program'];
    $occupation = $_POST['occupation'];
    $nominee_email = $_POST['nominee_email'];
    $nominee_phone = $_POST['nominee_phone'];
    $nominee_profile = $_POST['nominee_profile'];
    $nominator_name = $_POST['nominator_name'];
    $relationship = $_POST['relationship'];
    $organization = $_POST['organization'];
    $nominator_email = $_POST['nominator_email'];
    $nominator_phone = $_POST['nominator_phone'];
    $nominator_signature = $_POST['nominator_signature'];
    $nominator_date = $_POST['nominator_date'];
    $award_category = $_POST['award_category'];
    $achievements_summary = $_POST['achievements_summary'];
    $additional_info = $_POST['additional_info'];
    $nominee_signature = $_POST['nominee_signature'];
    $nominee_date = $_POST['nominee_date'];
    $nominator_declaration_signature = $_POST['nominator_declaration_signature'];
    $nominator_declaration_date = $_POST['nominator_declaration_date'];

    $evidence_documents = saveFiles($_FILES['evidence_documents'], "evidence");
    $supporting_documents = saveFiles($_FILES['supporting_documents'], "support");

    $stmt = $conn->prepare("INSERT INTO nominations (
        nominee_name, graduation_year, degree_program, occupation, nominee_email, nominee_phone, nominee_profile,
        nominator_name, relationship, organization, nominator_email, nominator_phone, nominator_signature, nominator_date,
        award_category, achievements_summary, additional_info, nominee_signature, nominee_date,
        nominator_declaration_signature, nominator_declaration_date, evidence_documents, supporting_documents
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param("sisssssssssssssssssssss",
        $nominee_name, $graduation_year, $degree_program, $occupation, $nominee_email, $nominee_phone, $nominee_profile,
        $nominator_name, $relationship, $organization, $nominator_email, $nominator_phone, $nominator_signature, $nominator_date,
        $award_category, $achievements_summary, $additional_info, $nominee_signature, $nominee_date,
        $nominator_declaration_signature, $nominator_declaration_date, $evidence_documents, $supporting_documents
    );

    if ($stmt->execute()) {
        echo "Nomination submitted successfully.";
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}
?>
